<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Painel - Gerador de Banner Personalizado</title>
    <!-- Google Fonts e Material Icons -->
    <link href="https://fonts.googleapis.com/css?family=Roboto:400,700|Poppins:400,700|Inter:400,700&display=swap" rel="stylesheet">
    <link href="https://fonts.googleapis.com/icon?family=Material+Icons" rel="stylesheet">
    <link rel="stylesheet" type="text/css" href="https://cdn.jsdelivr.net/npm/toastify-js/src/toastify.min.css">
    <style>
        body {
            font-family: 'Inter', 'Roboto', 'Poppins', Arial, sans-serif;
            margin: 0; padding: 0;
            background: linear-gradient(135deg, #141e30 0%, #243b55 100%);
            color: #fff;
            min-height: 100vh;
        }
        .container {
            max-width: 980px; margin: 32px auto;
            background: rgba(20, 30, 48, 0.97);
            padding: 32px 24px;
            border-radius: 18px;
            box-shadow: 0 0 32px #39FF1444;
            position: relative;
        }
        h1 {
            text-align: center;
            color: #39FF14;
            text-shadow: 0 0 12px #39FF1444;
            margin-bottom: 18px;
            font-size: 2.2rem;
            letter-spacing: 2px;
        }
        h2 {
            text-align: center;
            color: #39FF14;
            text-shadow: 0 0 8px #39FF1444;
            margin-top: 38px;
            margin-bottom: 16px;
            font-size: 1.4rem;
        }
        .header-buttons {
            display: flex;
            justify-content: center;
            align-items: center;
            gap: 22px;
            margin-bottom: 28px;
            flex-wrap: wrap;
        }
        .btn, .clear-cache-btn, .clear-all-banners-btn {
            min-width: 180px;
            background: linear-gradient(90deg, #39FF14, #FFD700);
            color: #222;
            padding: 13px 28px;
            border: none;
            border-radius: 8px;
            font-size: 16px;
            font-weight: bold;
            text-transform: uppercase;
            letter-spacing: 1px;
            box-shadow: 0 2px 10px #39FF1444;
            transition: background 0.2s, box-shadow 0.2s, transform 0.1s;
            display: flex; align-items: center; gap: 10px; justify-content: center;
            cursor: pointer;
        }
        .btn:active, .clear-cache-btn:active, .clear-all-banners-btn:active {
            transform: scale(0.97);
        }
        .clear-cache-btn:hover {
            background: linear-gradient(90deg, #FFD700, #39FF14);
        }
        .clear-all-banners-btn {
            background: linear-gradient(90deg, #FF4136, #FFD700);
            color: #fff;
        }
        .clear-all-banners-btn:hover {
            background: linear-gradient(90deg, #FFD700, #FF4136);
        }
        label {
            display: block;
            margin: 18px 0 8px;
            font-weight: 600;
            color: #FFD700;
            font-size: 1rem;
        }
        input[type="text"], select, input[type="file"], input[type="color"], input[type="number"], input[type="date"], input[type="time"] {
            width: 100%; padding: 12px 10px; margin-bottom: 8px;
            border: 2px solid #39FF14;
            border-radius: 7px;
            background: rgba(0,0,0,0.35);
            color: #fff; font-size: 16px; box-sizing: border-box;
            transition: border 0.2s, box-shadow 0.2s;
        }
        select, input[type="color"] { background: rgba(0,0,0,0.25); }
        input:focus, select:focus {
            outline: none;
            border-color: #fff;
            box-shadow: 0 0 10px #39FF1444;
        }
        .preview-container {
            margin: 10px 0 18px 0;
            display: flex;
            align-items: center;
            gap: 16px;
            justify-content: center;
            width: 100%;
        }
        .escudo-preview, .logo-preview {
            max-height: 92px; max-width: 120px;
            border: 2px solid #39FF14;
            border-radius: 7px;
            background: rgba(0,0,0,0.18); padding: 6px;
            box-shadow: 0 2px 8px #39FF1444;
            transition: box-shadow 0.2s, transform 0.2s;
        }
        .logo-preview { max-height: 110px; max-width: 200px; }
        .escudo-preview:hover, .logo-preview:hover {
            box-shadow: 0 4px 18px #39FF14;
            transform: scale(1.05);
        }
        .banner-preview {
            display: block;
            margin: 0 auto 16px auto;
            max-width: 320px;
            border-radius: 10px;
            box-shadow: 0 0 18px #39FF1444;
            transition: box-shadow 0.2s;
        }
        .banner-preview:hover { box-shadow: 0 0 28px #FFD70044; }
        .banners {
            margin-top: 38px;
            text-align: center;
            width: 100%;
        }
        .btn-destaque {
            display: block;
            margin: 32px auto 0 auto;
            background: linear-gradient(90deg, #39FF14, #FFD700);
            color: #222; font-size: 1.25rem; font-weight: bold;
            padding: 16px 0;
            width: 100%;
            border: none; border-radius: 8px;
            box-shadow: 0 6px 32px #39FF1444, 0 2px 8px #FFD70044;
            text-transform: uppercase; letter-spacing: 2px;
            cursor: pointer; transition: background 0.2s, box-shadow 0.2s, transform 0.1s;
        }
        .btn-destaque:hover {
            background: linear-gradient(90deg, #FFD700, #39FF14);
            box-shadow: 0 10px 40px #FFD70044;
            transform: translateY(-2px) scale(1.04);
        }
        .mensagem {
            text-align: center; color: #39FF14; font-weight: bold;
            margin: 14px 0 8px 0;
            text-shadow: 0 0 5px #39FF1444;
            font-size: 1.12rem;
        }
        .erro {
            text-align: center; color: #FF4136; font-weight: bold;
            margin: 14px 0 8px 0;
            text-shadow: 0 0 5px #FF413644;
            font-size: 1.12rem;
        }
        .search-container {
            display: flex;
            align-items: center;
            gap: 8px;
            margin-bottom: 8px;
        }
        .search-box {
            width: 80%;
            padding: 8px;
            border: 2px solid #39FF14;
            border-radius: 5px;
            background: rgba(0,0,0,0.25);
            color: #fff; font-size: 15px;
        }
        .clear-search-btn {
            width: 18%;
            padding: 8px;
            background: linear-gradient(90deg, #39FF14, #FFD700);
            color: #222;
            border: none; border-radius: 5px;
            font-size: 14px; font-weight: bold;
            text-transform: uppercase;
            transition: background 0.2s;
            cursor: pointer;
        }
        .clear-search-btn:hover {
            background: linear-gradient(90deg, #FFD700, #39FF14);
        }
        .dropzone {
            border: 2px dashed #39FF14;
            border-radius: 8px;
            background: rgba(57,255,20,0.04);
            color: #39FF14;
            padding: 18px; text-align: center; margin-bottom: 10px;
            transition: background 0.2s, border-color 0.2s;
            cursor: pointer;
        }
        .dropzone.dragover {
            background: rgba(57,255,20,0.14);
            border-color: #FFD700;
            color: #FFD700;
        }
        @media (max-width: 700px) {
            .container { padding: 8px; max-width: 98vw;}
            .header-buttons { flex-direction: column; gap: 12px; }
            .preview-container { flex-direction: column; }
            .banners { margin-top: 24px;}
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="header-buttons">
            <button onclick="clearCache()" class="clear-cache-btn"><span class="material-icons">refresh</span>Limpar Cache</button>
            <form id="clearAllBannersForm" action="admin.php" method="POST" style="display: inline;">
                <input type="hidden" name="apagar_todos_banners" value="1">
                <button type="button" onclick="clearAllBanners()" class="clear-all-banners-btn"><span class="material-icons">delete_sweep</span>Apagar Todos os Banners</button>
            </form>
        </div>
        <h1>Painel - Gerador de Banner Personalizado</h1>
        <?php
        $logo_padrao = 'logo/logo.png';
        if (isset($_GET['mensagem'])) {
            echo '<p class="mensagem">' . htmlspecialchars($_GET['mensagem']) . '</p>';
        }
        $escudos = [];
        foreach (glob('escudos/*.{png,jpg,jpeg}', GLOB_BRACE) as $arq) { $escudos[] = $arq; }
        $logos = [];
        foreach (glob('logo/*.{png,jpg,jpeg}', GLOB_BRACE) as $arq) { $logos[] = $arq; }
        ?>
        <form action="gerar_banner.php" method="POST" enctype="multipart/form-data" style="width:100%;max-width:420px;margin:0 auto;">
            <label>Selecionar Logo Existente</label>
            <select name="logo_existente" id="logo_existente" onchange="trocarLogo()">
                <?php foreach ($logos as $logo) { ?>
                    <option value="<?= htmlspecialchars($logo) ?>"<?= $logo == $logo_padrao ? ' selected' : '' ?>><?= basename($logo) ?></option>
                <?php } ?>
            </select>
            <div class="preview-container">
                <img id="img_logo_topo" class="logo-preview" src="<?= $logo_padrao ?>?t=<?= time() ?>" alt="Prévia da logo" style="display:inline;">
            </div>
            <label>Alterar Logo (PNG, JPG, JPEG)</label>
            <div class="dropzone" id="dropLogo">Arraste e solte o arquivo aqui ou clique para selecionar</div>
            <input type="file" id="upload_logo_input" name="upload_logo" accept="image/png, image/jpeg, image/jpg" style="display:none;" onchange="previewUpload('upload_logo_input', 'img_logo_topo')">
            <label>Imagem de Fundo do Banner (opcional)</label>
            <input type="file" name="fundo_personalizado" accept="image/png, image/jpeg, image/jpg">
            <label>Fonte do Título</label>
            <select name="fonte_titulo">
                <option value="BebasNeue-Regular.ttf">Bebas Neue</option>
                <option value="Oswald-Regular.ttf">Oswald</option>
                <option value="Roboto-Bold.ttf">Roboto Bold</option>
                <option value="Montserrat-Bold.ttf">Montserrat Bold</option>
            </select>
            <label>Fonte dos Times</label>
            <select name="fonte_times">
                <option value="BebasNeue-Regular.ttf">Bebas Neue</option>
                <option value="Oswald-Regular.ttf">Oswald</option>
                <option value="Roboto-Bold.ttf">Roboto Bold</option>
                <option value="Montserrat-Bold.ttf">Montserrat Bold</option>
            </select>
            <label>Fonte das Infos</label>
            <select name="fonte_info">
                <option value="Roboto-Regular.ttf">Roboto</option>
                <option value="Montserrat-Regular.ttf">Montserrat</option>
                <option value="Oswald-Regular.ttf">Oswald</option>
            </select>
            <label>Data do Jogo</label>
            <input type="date" name="data" required>
            <label>Horário</label>
            <input type="time" name="horario" required>
            <label>Título do Evento</label>
            <input type="text" name="titulo" value="SUPER JOGO 2025" required>
            <label>Subtítulo (opcional)</label>
            <input type="text" name="subtitulo" value="">
            <label>Competição ou Liga</label>
            <input type="text" name="liga" value="CAMPEONATO BRASILEIRO" required>
            <label>Time 1</label>
            <input type="text" name="time1" id="time1" value="TIME CASA" required>
            <label>Pesquisar Escudo Time 1</label>
            <div class="search-container">
                <input type="text" id="search_time1" class="search-box" placeholder="Digite o nome do time..." onkeyup="filterEscudos('search_time1', 'escudo_time1', 'time1')">
                <button type="button" class="clear-search-btn" onclick="clearSearch('search_time1', 'escudo_time1', 'time1', 'TIME CASA')">Limpar</button>
            </div>
            <label>Escudo Time 1</label>
            <select name="escudo_time1" id="escudo_time1" onchange="previewEscudo('escudo_time1','img_escudo1')">
                <option value="">Sem escudo</option>
                <?php foreach ($escudos as $esc) { ?>
                    <option value="<?= htmlspecialchars($esc) ?>"><?= basename($esc) ?></option>
                <?php } ?>
            </select>
            <div class="preview-container">
                <img id="img_escudo1" class="escudo-preview" src="" alt="" style="display: none;">
            </div>
            <label>Time 2</label>
            <input type="text" name="time2" id="time2" value="TIME VISITANTE" required>
            <label>Pesquisar Escudo Time 2</label>
            <div class="search-container">
                <input type="text" id="search_time2" class="search-box" placeholder="Digite o nome do time..." onkeyup="filterEscudos('search_time2', 'escudo_time2', 'time2')">
                <button type="button" class="clear-search-btn" onclick="clearSearch('search_time2', 'escudo_time2', 'time2', 'TIME VISITANTE')">Limpar</button>
            </div>
            <label>Escudo Time 2</label>
            <select name="escudo_time2" id="escudo_time2" onchange="previewEscudo('escudo_time2','img_escudo2')">
                <option value="">Sem escudo</option>
                <?php foreach ($escudos as $esc) { ?>
                    <option value="<?= htmlspecialchars($esc) ?>"><?= basename($esc) ?></option>
                <?php } ?>
            </select>
            <div class="preview-container">
                <img id="img_escudo2" class="escudo-preview" src="" alt="" style="display: none;">
            </div>
            <label>Texto de Confronto (ex.: VS, X)</label>
            <input type="text" name="confronto" value="VS" required>
            <label>Canal/Streaming</label>
            <input type="text" name="canal" value="TV ESPORTE 2025" required>
            <label>Qualidade do Streaming</label>
            <input type="text" name="qualidade" value="4K ULTRA HD" required>
            <label>Plano de Assinatura</label>
            <input type="text" name="plano" value="PLANO PREMIUM IPTV" required>
            <label>Mensagem Extra (opcional)</label>
            <input type="text" name="mensagem_extra" value="">
            <button type="submit" class="btn-destaque generate-btn"><span class="material-icons">auto_awesome</span>Gerar Banner</button>
        </form>
        <div class="banners">
            <h2>Prévia do Banner</h2>
            <img src="img/banner_futebol.png?t=<?= time() ?>" alt="Prévia do Banner" class="banner-preview" id="banner_preview">
            <div style="margin-top:24px;">
                <?php
                $banner_file = 'img/banner_futebol.png';
                if (file_exists($banner_file)) {
                    echo '<a href="' . $banner_file . '" download="banner_futebol.png" class="btn-destaque" style="padding:12px 0;margin:0 auto;font-size:1.08rem;width:100%;"><span class="material-icons" style="font-size:1.2em;">cloud_download</span>Baixar Banner</a>';
                } else {
                    echo '<span style="color:#FFD700;">Nenhum banner gerado ainda.</span>';
                }
                ?>
            </div>
        </div>
    </div>
    <script type="text/javascript" src="https://cdn.jsdelivr.net/npm/toastify-js"></script>
    <script>
        function showToast(msg, type='success') {
            Toastify({
                text: msg,
                duration: 2800,
                gravity: "top",
                position: "center",
                backgroundColor: type === 'success' ? "#39FF14" : "#FF4136",
                stopOnFocus: true,
                style: { borderRadius: "8px", fontWeight: "bold", fontFamily: "Inter, Roboto, Arial" }
            }).showToast();
        }
        const dropLogo = document.getElementById('dropLogo');
        const uploadLogoInput = document.getElementById('upload_logo_input');
        dropLogo.onclick = () => uploadLogoInput.click();
        dropLogo.addEventListener('dragover', function(e) {
            e.preventDefault(); dropLogo.classList.add('dragover');
        });
        dropLogo.addEventListener('dragleave', function(e) {
            e.preventDefault(); dropLogo.classList.remove('dragover');
        });
        dropLogo.addEventListener('drop', function(e) {
            e.preventDefault(); dropLogo.classList.remove('dragover');
            if (e.dataTransfer.files.length) {
                uploadLogoInput.files = e.dataTransfer.files;
                previewUpload('upload_logo_input', 'img_logo_topo');
                showToast('Logo carregada com sucesso!');
            }
        });
        function previewUpload(inputId, imgId) {
            var input = document.getElementById(inputId);
            var img = document.getElementById(imgId);
            if (input.files && input.files[0]) {
                var reader = new FileReader();
                reader.onload = function(e) { img.src = e.target.result; img.style.display = 'inline'; };
                reader.readAsDataURL(input.files[0]);
            }
        }
        function previewEscudo(selectId, imgId) {
            var select = document.getElementById(selectId);
            var img = document.getElementById(imgId);
            if (select.value) { img.src = select.value; img.style.display = 'inline'; } else { img.src = ''; img.style.display = 'none'; }
        }
        function filterEscudos(inputId, selectId, timeInputId) {
            var input = document.getElementById(inputId);
            var select = document.getElementById(selectId);
            var timeInput = document.getElementById(timeInputId);
            var filter = input.value.toLowerCase();
            var options = select.getElementsByTagName('option');
            var firstMatch = null;
            for (var i = 0; i < options.length; i++) {
                var txtValue = options[i].textContent.toLowerCase();
                if (txtValue.includes(filter) || options[i].value === '') {
                    options[i].style.display = '';
                    if (options[i].value !== '' && firstMatch === null && txtValue.includes(filter)) { firstMatch = options[i]; }
                } else { options[i].style.display = 'none'; }
            }
            if (firstMatch) {
                select.value = firstMatch.value;
                timeInput.value = firstMatch.textContent.split('.')[0].toUpperCase();
                previewEscudo(selectId, 'img_' + selectId.split('_')[1]);
            }
        }
        function clearSearch(inputId, selectId, timeInputId, defaultTime) {
            var input = document.getElementById(inputId);
            var select = document.getElementById(selectId);
            var timeInput = document.getElementById(timeInputId);
            input.value = '';
            select.value = '';
            timeInput.value = defaultTime;
            previewEscudo(selectId, 'img_' + selectId.split('_')[1]);
            var options = select.getElementsByTagName('option');
            for (var i = 0; i < options.length; i++) { options[i].style.display = ''; }
        }
        function clearCache() {
            showToast('Cache limpo!', 'success');
            setTimeout(() => window.location.reload(true), 1000);
        }
        function clearAllBanners() {
            if (confirm('Tem certeza que deseja apagar TODOS os banners gerados? Esta ação não pode ser desfeita.')) {
                showToast('Todos os banners apagados!', 'success');
                setTimeout(() => document.getElementById('clearAllBannersForm').submit(), 1000);
            }
        }
        function trocarLogo() {
            var sel = document.getElementById('logo_existente');
            var img = document.getElementById('img_logo_topo');
            if(sel.value) img.src = sel.value + '?t=' + Date.now();
        }
    </script>
</body>
</html>
