<?php

// Defina sua chave de API do TMDb aqui
$apiKey = '855ee921df930db2f2a9669eda268032';
$baseUrl = 'https://api.themoviedb.org/3';

// Função para obter filmes recentes
function getRecentMovies($apiKey, $baseUrl)
{
    $url = $baseUrl . '/movie/now_playing?api_key=' . $apiKey . '&language=pt-BR&page=1';
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
    curl_setopt($ch, CURLOPT_TIMEOUT, 10);
    $response = curl_exec($ch);
    if (curl_errno($ch)) {
        return json_encode(['error' => 'Erro: ' . curl_error($ch)]);
    }
    curl_close($ch);
    $data = json_decode($response, true);
    return isset($data['results']) ? $data['results'] : [];
}

// Função para obter gêneros de filmes
function getGenres($apiKey, $baseUrl)
{
    $url = $baseUrl . '/genre/movie/list?api_key=' . $apiKey . '&language=pt-BR';
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
    curl_setopt($ch, CURLOPT_TIMEOUT, 10);
    $response = curl_exec($ch);
    if (curl_errno($ch)) {
        return json_encode(['error' => 'Erro: ' . curl_error($ch)]);
    }
    curl_close($ch);
    $data = json_decode($response, true);
    $genres = [];
    foreach ($data['genres'] as $genre) {
        $genres[$genre['id']] = $genre['name'];
    }
    return $genres;
}

// Cabeçalho para exibir conteúdo HTML
header('Content-Type: text/html; charset=UTF-8');

// Obtendo filmes recentes e gêneros
$movies = getRecentMovies($apiKey, $baseUrl);
$genres = getGenres($apiKey, $baseUrl);

?>
<!DOCTYPE html>
<html lang="pt-BR">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Últimos Lançamentos de Filmes</title>
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            font-family: Arial, sans-serif;
            background-color: #222;
            color: white;
        }

        .carousel-container {
            position: relative;
            width: 100%;
            overflow: hidden;
        }

        .carousel-slide {
            display: flex;
            transition: transform 1s ease-in-out;
        }

        .carousel-item {
            min-width: 100%;
            height: 100vh;
            background-size: cover;
            background-position: center;
            position: relative;
        }

        .carousel-caption {
            position: absolute;
            top: 50%;
            left: 50%;
            transform: translate(-50%, -50%);
            color: white;
            text-shadow: 2px 2px 10px rgba(0, 0, 0, 0.7);
            width: 100%;
            background-color: rgba(0, 0, 0, 0.6);
            padding: 20px;
            align-items: center;
            text-align: center;
        }

        .carousel-caption p,
        h3 {

            margin-bottom: 10px;
        }

        .carousel-indicators {
            position: absolute;
            bottom: 20px;
            left: 50%;
            transform: translateX(-50%);
            display: flex;
            list-style: none;
        }

        .carousel-indicators li {
            width: 10px;
            height: 10px;
            margin: 0 5px;
            background-color: rgba(0, 0, 0, 0);
            border-radius: 50%;
            cursor: pointer;
        }

        .carousel-indicators .active {
            background-color: rgba(0, 0, 0, 0);
        }
    </style>
</head>

<body>

    <div class="carousel-container">
        <div class="carousel-slide">
            <?php
            if (!empty($movies)) {
                foreach ($movies as $index => $movie) {
                    $title = htmlspecialchars($movie['title']);
                    $releaseDate = htmlspecialchars($movie['release_date']);
                    $overview = htmlspecialchars($movie['overview']);
                    $backdropPath = $movie['backdrop_path'] ? 'https://image.tmdb.org/t/p/w1280' . $movie['backdrop_path'] : 'https://via.placeholder.com/1280x720?text=Sem+Imagem+de+Fundo';
                    $voteAverage = round($movie['vote_average'], 1);
                    $voteCount = $movie['vote_count'];

                    // Gêneros
                    $genreNames = [];
                    foreach ($movie['genre_ids'] as $genreId) {
                        if (isset($genres[$genreId])) {
                            $genreNames[] = $genres[$genreId];
                        }
                    }
                    $genresFormatted = implode(', ', $genreNames);
            ?>
                    <div class="carousel-item" style="background-image: url('<?php echo $backdropPath; ?>');">
                        <div class="carousel-caption">
                            <h3><strong><?php echo $title; ?></strong></h3>
                            <p><strong></strong> <?php echo $genresFormatted; ?></p>
                            <p><strong>⭐</strong> <?php echo $voteAverage; ?> (<?php echo $voteCount; ?> votos)</p>
                        </div>
                    </div>
            <?php
                }
            }
            ?>
        </div>

        <ul class="carousel-indicators">
            <?php foreach ($movies as $index => $movie) { ?>
                <li data-slide-to="<?php echo $index; ?>" class="<?php echo $index === 0 ? 'active' : ''; ?>"></li>
            <?php } ?>
        </ul>
    </div>

    <script>
        const indicators = document.querySelectorAll('.carousel-indicators li');
        const slideContainer = document.querySelector('.carousel-slide');
        let currentIndex = 0;

        function goToSlide(index) {
            if (index < 0) index = indicators.length - 1;
            if (index >= indicators.length) index = 0;
            slideContainer.style.transform = `translateX(-${index * 100}%)`;

            // Update active indicator
            indicators.forEach((indicator, i) => {
                indicator.classList.toggle('active', i === index);
            });

            currentIndex = index;
        }

        // Set the interval to change slides automatically every 5 seconds
        setInterval(() => {
            goToSlide(currentIndex + 1);
        }, 5000);

        // Initial call to position the carousel
        goToSlide(currentIndex);
    </script>

</body>

</html>