<?php
session_start();
if (isset($_SESSION['logado']) && $_SESSION['logado'] === true && !isset($_GET['admin'])) {
    header("Location: index.php");
    exit();
}
if (isset($_SESSION['admin_logado']) && $_SESSION['admin_logado'] === true && isset($_GET['admin'])) {
    header("Location: admin.php");
    exit();
}
$config_file = __DIR__ . '/config.json';
$config = file_exists($config_file) ? json_decode(file_get_contents($config_file), true) : [];
$api_key = '855ee921df930db2f2a9669eda268032';
$api_url = "https://api.themoviedb.org/3/movie/popular?api_key={$api_key}&language=pt-BR&page=1";
$response = @file_get_contents($api_url);
if ($response !== false) {
    $data = json_decode($response, true);
    $movies = $data['results'];
} else {
    $movies = [];
}
if ($_SERVER["REQUEST_METHOD"] === 'POST') {
    $usuario = $_POST['usuario'];
    $senha = $_POST['senha'];
    $is_admin = isset($_GET['admin']) && $_GET['admin'] == 1;
    if ($is_admin) {
        if ($usuario === ($config['admin_user'] ?? 'admin_panel') && $senha === ($config['admin_password'] ?? 'admin123')) {
            $_SESSION['admin_logado'] = true;
            header("Location: admin.php");
            exit();
        } else {
            $erro = 'Usuário ou senha incorretos para o painel admin!';
        }
    } else {
        if ($usuario === ($config['main_user'] ?? 'admin') && $senha === ($config['main_password'] ?? '102030')) {
            $_SESSION['logado'] = true;
            header("Location: index.php");
            exit();
        } else {
            $erro = 'Usuário ou senha incorretos!';
        }
    }
}
// Logo dinâmica (ajuste se quiser buscar da pasta logo/)
$logo_path = 'img/logo.png';
if (file_exists(__DIR__ . '/logo/logo.png')) {
    $logo_path = 'logo/logo.png?v=' . filemtime(__DIR__ . '/logo/logo.png');
}
?>
<!DOCTYPE html>
<html lang="pt-br">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Login com Capas TMDB</title>
    <style>
        html, body {
            font-family: 'Segoe UI', Arial, sans-serif;
            height: 100%;
            background: linear-gradient(135deg, #141e30 0%, #243b55 100%);
            color: #fff;
            overflow: hidden;
        }
        body {
            display: flex;
            justify-content: center;
            align-items: center;
            min-height: 100vh;
            position: relative;
        }
        .waterfall-container {
            position: absolute;
            top: 0; left: 0;
            width: 100%; height: 100%;
            z-index: 1;
            pointer-events: none;
        }
        .falling-poster {
            position: absolute;
            width: 80px; height: 120px;
            opacity: 0.7;
            filter: drop-shadow(0 4px 8px #0008);
            animation: fall linear infinite;
            border-radius: 8px;
            transition: opacity 0.3s;
        }
        @keyframes fall {
            0% { transform: translateY(-150px) rotate(0deg); opacity: 0;}
            20% { opacity: 1;}
            100% { transform: translateY(110vh) rotate(360deg); opacity: 0;}
        }
        .login-box {
            position: relative;
            z-index: 2;
            background: rgba(20, 30, 48, 0.92);
            padding: 40px 30px 32px 30px;
            max-width: 350px;
            width: 100%;
            border-radius: 18px;
            box-shadow: 0 0 28px <?= $config['login_border_color'] ?? '#39FF14' ?>44;
            text-align: center;
            animation: fadein 1s;
            box-sizing: border-box;
        }
        @keyframes fadein { from { opacity: 0; transform: scale(0.95);} to { opacity: 1; transform: scale(1);} }
        .login-box img.logo {
            max-width: 120px;
            margin-bottom: 18px;
            border-radius: 50%;
            box-shadow: 0 0 24px #fff5, 0 0 0 8px #39FF1422;
            background: #fff1;
        }
        .input-group {
            position: relative;
            margin-bottom: 18px;
            width: 100%;
            box-sizing: border-box;
        }
        .input-group svg.icon-left {
            position: absolute;
            left: 12px;
            top: 50%;
            transform: translateY(-50%);
            width: 22px;
            height: 22px;
            fill: #39FF14;
            opacity: 0.88;
            pointer-events: none;
        }
        .input-group input {
            width: 100%;
            box-sizing: border-box;
            padding: 13px 44px 13px 42px;
            font-size: 16px;
            border: 2px solid <?= $config['login_border_color'] ?? '#39FF14' ?>;
            border-radius: 7px;
            background: rgba(0,0,0,0.35);
            color: #fff;
            outline: none;
            transition: border 0.2s;
            display: block;
        }
        .input-group input:focus {
            border-color: #fff;
        }
        /* Ajuste apenas para o campo de senha */
        .input-group.password-group input {
            padding-right: 48px !important;
        }
        .input-group .show-password-btn {
            position: absolute;
            right: 16px;
            top: 50%;
            transform: translateY(-50%);
            background: none;
            border: none;
            cursor: pointer;
            padding: 0;
            outline: none;
            z-index: 3;
            display: flex;
            align-items: center;
        }
        .input-group .show-password-btn svg {
            width: 22px;
            height: 22px;
            fill: #aaa;
            opacity: 0.85;
        }
        .input-group .show-password-btn:active svg,
        .input-group .show-password-btn:focus svg {
            fill: #39FF14;
        }
        .login-box button[type="submit"] {
            width: 100%;
            padding: 14px;
            margin-top: 6px;
            background: linear-gradient(90deg, #39FF14, #FFD700);
            border: none;
            border-radius: 8px;
            font-weight: bold;
            font-size: 17px;
            color: #222;
            cursor: pointer;
            box-shadow: 0 2px 8px #39FF1444;
            transition: background 0.2s;
        }
        .login-box button[type="submit"]:hover {
            background: linear-gradient(90deg, #FFD700, #39FF14);
        }
        .error {
            color: #FF4136;
            margin-top: 12px;
            font-size: 15px;
            background: #fff2;
            border-radius: 6px;
            padding: 7px;
        }
        @media (max-width: 480px) {
            .login-box { padding: 18px 8px;}
            .falling-poster { width: 60px; height: 90px;}
            .login-box img.logo { max-width: 80px;}
        }
    </style>
</head>
<body>
    <div class="waterfall-container">
        <?php foreach ($movies as $movie): ?>
            <?php for ($i = 0; $i < 2; $i++): ?>
                <img class="falling-poster" 
                     src="https://image.tmdb.org/t/p/w200<?php echo $movie['poster_path']; ?>" 
                     alt="<?php echo htmlspecialchars($movie['title']); ?>" 
                     style="
                        left: <?php echo rand(0, 100); ?>vw;
                        animation-duration: <?php echo rand(10, 20); ?>s;
                        animation-delay: <?php echo rand(0, 10); ?>s;
                     ">
            <?php endfor; ?>
        <?php endforeach; ?>
    </div>
    <div class="login-box">
        <img class="logo" src="<?= htmlspecialchars($logo_path) ?>" alt="Logo do site">
        <form method="POST" autocomplete="off">
            <div class="input-group">
                <svg class="icon-left" viewBox="0 0 24 24"><path d="M12 12c2.7 0 5-2.3 5-5s-2.3-5-5-5-5 2.3-5 5 2.3 5 5 5zm0 2c-3.3 0-10 1.7-10 5v3h20v-3c0-3.3-6.7-5-10-5z"/></svg>
                <input type="text" name="usuario" placeholder="Usuário" required autofocus>
            </div>
            <div class="input-group password-group">
                <svg class="icon-left" viewBox="0 0 24 24"><path d="M12 17a2 2 0 1 0 0-4 2 2 0 0 0 0 4zm6-7V7a6 6 0 0 0-12 0v3a2 2 0 0 0-2 2v8a2 2 0 0 0 2 2h12a2 2 0 0 0 2-2v-8a2 2 0 0 0-2-2zm-8-3a4 4 0 0 1 8 0v3H6V7zm10 13H4v-8h16v8z"/></svg>
                <input type="password" name="senha" id="senha" placeholder="Senha" required autocomplete="off">
                <button type="button" class="show-password-btn" onclick="togglePassword()" tabindex="-1" aria-label="Mostrar/ocultar senha">
                    <svg id="eye" viewBox="0 0 24 24"><path d="M12 5c-7 0-11 7-11 7s4 7 11 7 11-7 11-7-4-7-11-7zm0 12c-2.8 0-5-2.2-5-5s2.2-5 5-5 5 2.2 5 5-2.2 5-5 5zm0-8a3 3 0 1 0 0 6 3 3 0 0 0 0-6z"/></svg>
                </button>
            </div>
            <button type="submit">Entrar</button>
        </form>
        <?php if (isset($erro)): ?>
            <p class="error"><?php echo htmlspecialchars($erro); ?></p>
        <?php endif; ?>
    </div>
    <script>
        function togglePassword() {
            const senha = document.getElementById('senha');
            const eye = document.getElementById('eye');
            if (senha.type === "password") {
                senha.type = "text";
                eye.innerHTML = '<path d="M12 5c-7 0-11 7-11 7s4 7 11 7c2.2 0 4.2-0.5 6-1.4l2.1 2.1 1.4-1.4-19-19-1.4 1.4 2.7 2.7c-1.2 1-2.2 2.2-2.8 3.6 1.7 3.3 6 7 11 7 1.6 0 3.1-0.3 4.5-0.8l1.5 1.5c-2 0.7-4.2 1.1-6 1.1-7 0-11-7-11-7s4-7 11-7c1.8 0 4 0.4 6 1.1l1.5-1.5c-1.4-0.5-2.9-0.8-4.5-0.8z"/>';
            } else {
                senha.type = "password";
                eye.innerHTML = '<path d="M12 5c-7 0-11 7-11 7s4 7 11 7 11-7 11-7-4-7-11-7zm0 12c-2.8 0-5-2.2-5-5s2.2-5 5-5 5 2.2 5 5-2.2 5-5 5zm0-8a3 3 0 1 0 0 6 3 3 0 0 0 0-6z"/>';
            }
        }
    </script>
</body>
</html>
