<?php
session_start();
if (!isset($_SESSION['logado']) || $_SESSION['logado'] !== true) {
    header("Location: login.php");
    exit();
}

$apagados = null;
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $imgDir = __DIR__ . '/img/';
    $arquivos = glob($imgDir . '*banner*.*');
    $apagados = 0;
    foreach ($arquivos as $arquivo) {
        $ext = strtolower(pathinfo($arquivo, PATHINFO_EXTENSION));
        if (in_array($ext, ['jpg', 'jpeg', 'png', 'webp', 'gif'])) {
            if (unlink($arquivo)) $apagados++;
        }
    }
}
?>
<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <title>Apagar Banners</title>
</head>
<body>
    <h2>Apagar Imagens de Banner na Pasta img/</h2>
    <?php
    if ($apagados !== null) {
        echo "<p style='color:green;'>$apagados imagem(ns) apagada(s)!</p>";
    }
    ?>
    <form method="POST" onsubmit="return confirm('Tem certeza que deseja apagar todas as imagens de banner na pasta img?');">
        <button type="submit" style="background:#ff4757;color:#fff;">Apagar Imagens de Banner</button>
    </form>
    <p><a href="upload_logo.php">Voltar para upload de logo</a></p>
</body>
</html>
