<?php
header('Content-Type: application/json');

$apiKey = '855ee921df930db2f2a9669eda268032';
$language = 'pt-BR';

$tipo = isset($_GET['tipo']) ? strtolower($_GET['tipo']) : 'filme';
$query = isset($_GET['query']) ? urlencode($_GET['query']) : '';
$page = isset($_GET['page']) ? intval($_GET['page']) : 1;

if (empty($query)) {
    echo json_encode([]);
    exit;
}

// Define endpoint com base no tipo
switch ($tipo) {
    case 'filme':
        $endpoint = 'search/movie';
        break;
    case 'serie':
    case 'novela':
    case 'anime':
        $endpoint = 'search/tv';
        break;
    default:
        echo json_encode(['erro' => 'Tipo inválido']);
        exit;
}

// Faz a requisição à API
$url = "https://api.themoviedb.org/3/{$endpoint}?api_key=$apiKey&language=$language&query=$query&page=$page";
$response = file_get_contents($url);
$data = json_decode($response, true);

// Monta os resultados
$resultados = [];

if (!empty($data['results'])) {
    foreach ($data['results'] as $item) {
        if (!empty($item['poster_path'])) {
            $titulo = isset($item['title']) ? $item['title'] : $item['name'];
            $resultados[] = [
                'id' => $item['id'],
                'titulo' => $titulo,
                'poster' => "https://image.tmdb.org/t/p/w342" . $item['poster_path']
            ];
        }
    }
}

echo json_encode($resultados);
