<?php
ob_start();
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

function get_post($key, $default = '') {
    return isset($_POST[$key]) ? $_POST[$key] : $default;
}

// Função para garantir fonte válida
function fonte_valida($preferidas = []) {
    $dir = __DIR__ . '/fonts/';
    foreach ($preferidas as $fonte) {
        $caminho = realpath($dir . $fonte);
        if ($caminho && file_exists($caminho)) return $caminho;
    }
    foreach (glob($dir . '*.ttf') as $arquivo) {
        if (file_exists($arquivo)) return realpath($arquivo);
    }
    return false;
}

// Função para traduzir o mês inteiro para português
function traduz_mes_inteiro($data) {
    $meses = [
        'January' => 'JANEIRO',    'February' => 'FEVEREIRO', 'March' => 'MARÇO',     'April' => 'ABRIL',
        'May' => 'MAIO',           'June' => 'JUNHO',         'July' => 'JULHO',      'August' => 'AGOSTO',
        'September' => 'SETEMBRO', 'October' => 'OUTUBRO',    'November' => 'NOVEMBRO','December' => 'DEZEMBRO'
    ];
    $str = date('d F Y', strtotime($data));
    return strtr($str, $meses);
}

// Recebe campos do painel
$data        = get_post('data', date('Y-m-d'));
$horario     = get_post('horario', date('H:i'));
$titulo      = get_post('titulo', 'SUPER JOGO 2025');
$subtitulo   = get_post('subtitulo', '');
$liga        = get_post('liga', 'CAMPEONATO BRASILEIRO');
$time1       = get_post('time1', 'TIME CASA');
$time2       = get_post('time2', 'TIME VISITANTE');
$confronto   = get_post('confronto', 'VS');
$canal       = get_post('canal', 'TV ESPORTE 2025');
$qualidade   = get_post('qualidade', '4K ULTRA HD');
$plano       = get_post('plano', 'PLANO PREMIUM IPTV');
$mensagem_extra = get_post('mensagem_extra', '');

// Botão SEM texto
$texto_botao = '';

// Cores e fontes
$cor_fundo   = get_post('cor_fundo', '#16213e');
$cor_texto   = get_post('cor_texto', '#e0e0e0');
$cor_botao   = get_post('cor_botao', '#00e5ff');
$fonte_titulo= get_post('fonte_titulo', 'BebasNeue-Regular.ttf');
$fonte_times = get_post('fonte_times', 'BebasNeue-Regular.ttf');
$fonte_info  = get_post('fonte_info', 'Roboto-Regular.ttf');
$cor_overlay = get_post('cor_overlay', '#000000');
$opacidade_overlay = intval(get_post('opacidade_overlay', 40));
$alinhamento = get_post('alinhamento', 'center');
$espacamento = intval(get_post('espacamento', 60));
$sombra_texto= get_post('sombra_texto', '1') === '1';
$glow_escudos= get_post('glow_escudos', '1') === '1';

// Dimensões fixas (vertical)
$largura = 1080;
$altura = 1350;

// Caminhos das fontes (sempre válidos)
$fonte_path_titulo = fonte_valida([$fonte_titulo, $fonte_times, $fonte_info]);
$fonte_path_times  = fonte_valida([$fonte_times, $fonte_titulo, $fonte_info]);
$fonte_path_info   = fonte_valida([$fonte_info, $fonte_times, $fonte_titulo]);

if (!$fonte_path_titulo || !$fonte_path_times || !$fonte_path_info) {
    die('Nenhuma fonte válida encontrada na pasta fonts/.');
}

// Logo topo (selecionada)
$logo_padrao = isset($_POST['logo_existente']) && file_exists($_POST['logo_existente'])
    ? $_POST['logo_existente']
    : 'logo/logo.png';

// Upload de nova logo (opcional)
if (isset($_FILES['upload_logo']) && $_FILES['upload_logo']['error'] == 0) {
    $ext = strtolower(pathinfo($_FILES['upload_logo']['name'], PATHINFO_EXTENSION));
    if (in_array($ext, ['png', 'jpg', 'jpeg'])) {
        $logo_dest = 'logo/' . uniqid('logo_') . '.' . $ext;
        move_uploaded_file($_FILES['upload_logo']['tmp_name'], $logo_dest);
        $logo_padrao = $logo_dest;
    }
}

// Upload de fundo personalizado (opcional)
$fundo_path = 'img/fundo.jpg';
if (isset($_FILES['fundo_personalizado']) && $_FILES['fundo_personalizado']['error'] == 0) {
    $ext = strtolower(pathinfo($_FILES['fundo_personalizado']['name'], PATHINFO_EXTENSION));
    if (in_array($ext, ['png', 'jpg', 'jpeg'])) {
        $fundo_dest = 'img/fundo_' . uniqid() . '.' . $ext;
        move_uploaded_file($_FILES['fundo_personalizado']['tmp_name'], $fundo_dest);
        $fundo_path = $fundo_dest;
    }
}

// Escudos
$logoPathTime1 = get_post('escudo_time1', '');
$logoPathTime2 = get_post('escudo_time2', '');

// Bola
$bola_path = 'bola.png';

// Botão rodapé
$botao_path = 'img/botao.png';

// Pasta de saída
$pasta = 'img/';
if (!is_dir($pasta)) mkdir($pasta, 0755, true);
if (!is_writable($pasta)) die("Erro: A pasta img/ não tem permissões de escrita.");

// Banner antigo
$banner_antigo = $pasta . 'banner_futebol.png';
if (file_exists($banner_antigo)) @unlink($banner_antigo);

// Criação da imagem base
$img = imagecreatetruecolor($largura, $altura);

// Fundo sólido
list($r, $g, $b) = sscanf($cor_fundo, "#%02x%02x%02x");
$cor_fundo_img = imagecolorallocate($img, $r, $g, $b);
imagefilledrectangle($img, 0, 0, $largura, $altura, $cor_fundo_img);

// Fundo imagem, se houver
if (file_exists($fundo_path)) {
    $ext = strtolower(pathinfo($fundo_path, PATHINFO_EXTENSION));
    $fundo = ($ext === 'png') ? imagecreatefrompng($fundo_path) : imagecreatefromjpeg($fundo_path);
    if ($fundo) {
        imagecopyresampled($img, $fundo, 0, 0, 0, 0, $largura, $altura, imagesx($fundo), imagesy($fundo));
        imagedestroy($fundo);
    }
}

// Overlay colorido
list($ro, $go, $bo) = sscanf($cor_overlay, "#%02x%02x%02x");
$overlay = imagecolorallocatealpha($img, $ro, $go, $bo, 127 - intval($opacidade_overlay * 1.27));
imagefilledrectangle($img, 0, 0, $largura, $altura, $overlay);

// Cor única para todos os textos
list($rt, $gt, $bt) = sscanf($cor_texto, "#%02x%02x%02x");
$cor_texto_unica = imagecolorallocate($img, $rt, $gt, $bt);

// Centralização
function alinhar($alinhamento, $largura, $text_box, $x_pad = 0) {
    $text_width = $text_box[2] - $text_box[0];
    if ($alinhamento == 'left') return $x_pad;
    if ($alinhamento == 'right') return $largura - $text_width - $x_pad;
    return ($largura - $text_width) / 2;
}

// --- Layout ---
$y = 40;

// Logo topo - destaque
if (file_exists($logo_padrao)) {
    $logoTopo = imagecreatefromstring(file_get_contents($logo_padrao));
    $logo_w = imagesx($logoTopo); $logo_h = imagesy($logoTopo);
    $max_logo = intval($largura * 0.32);
    $logo_nw = $max_logo;
    $logo_nh = ($logo_h * $max_logo) / $logo_w;
    $logo_x = ($largura - $logo_nw) / 2;
    imagecopyresampled($img, $logoTopo, $logo_x, $y, 0, 0, $logo_nw, $logo_nh, $logo_w, $logo_h);
    $y += $logo_nh + 48;
    imagedestroy($logoTopo);
}

// Data e horário (com mês inteiro em português)
$data_font = 38;
$data_str = '';
if ($data) {
    $data_str = (preg_match('/^\d{4}-\d{2}-\d{2}$/', $data)) ? traduz_mes_inteiro($data) : strtoupper($data);
}
$hora_str = $horario;
$datahora_str = trim($data_str . ($data_str && $hora_str ? ' - ' : '') . $hora_str);
$datahora_box = imagettfbbox($data_font, 0, $fonte_path_info, $datahora_str);
$datahora_x = alinhar($alinhamento, $largura, $datahora_box, 40);
$datahora_height = abs($datahora_box[7] - $datahora_box[1]);
imagettftext($img, $data_font, 0, $datahora_x, $y + $datahora_height, $cor_texto_unica, $fonte_path_info, $datahora_str);
$y += $datahora_height + 22;

// Título
$titulo_font = 66;
$titulo_str = strtoupper($titulo);
$titulo_box = imagettfbbox($titulo_font, 0, $fonte_path_titulo, $titulo_str);
$titulo_x = alinhar($alinhamento, $largura, $titulo_box, 40);
$titulo_height = abs($titulo_box[7] - $titulo_box[1]);
if ($sombra_texto) imagettftext($img, $titulo_font, 0, $titulo_x+2, $y+2+$titulo_height, imagecolorallocatealpha($img,0,0,0,70), $fonte_path_titulo, $titulo_str);
imagettftext($img, $titulo_font, 0, $titulo_x, $y + $titulo_height, $cor_texto_unica, $fonte_path_titulo, $titulo_str);
$y += $titulo_height + 16;

// TEXTO INFORMATIVO ABAIXO DO TÍTULO
$info = "{$canal} | {$qualidade} | {$plano}";
$info_font = 32;
$info_box = imagettfbbox($info_font, 0, $fonte_path_info, $info);
$info_x = alinhar($alinhamento, $largura, $info_box, 40);
$info_height = abs($info_box[7] - $info_box[1]);
imagettftext($img, $info_font, 0, $info_x, $y + $info_height, $cor_texto_unica, $fonte_path_info, $info);
$y += $info_height + 28;

// Subtítulo
if ($subtitulo) {
    $subt_font = 38;
    $subt_box = imagettfbbox($subt_font, 0, $fonte_path_info, $subtitulo);
    $subt_x = alinhar($alinhamento, $largura, $subt_box, 40);
    $subt_height = abs($subt_box[7] - $subt_box[1]);
    imagettftext($img, $subt_font, 0, $subt_x, $y + $subt_height, $cor_texto_unica, $fonte_path_info, $subtitulo);
    $y += $subt_height + 18;
}

// Liga (campeonato) MAIOR e destacado
$liga_font = 54; // aumente aqui para maior destaque
$liga_str = strtoupper($liga);
$liga_box = imagettfbbox($liga_font, 0, $fonte_path_info, $liga_str);
$liga_x = alinhar($alinhamento, $largura, $liga_box, 40);
$liga_height = abs($liga_box[7] - $liga_box[1]);
imagettftext($img, $liga_font, 0, $liga_x, $y + $liga_height, $cor_texto_unica, $fonte_path_info, $liga_str);
$y += $liga_height + $espacamento;

// Escudos e bola
$escudo_tam = intval($largura * 0.18);
$escudo_y = $y;
if ($logoPathTime1 && file_exists($logoPathTime1)) {
    $logo1 = imagecreatefromstring(file_get_contents($logoPathTime1));
    $logo1_w = imagesx($logo1); $logo1_h = imagesy($logo1);
    $x1 = 80;
    imagecopyresampled($img, $logo1, $x1, $escudo_y, 0, 0, $escudo_tam, $escudo_tam, $logo1_w, $logo1_h);
    imagedestroy($logo1);
}
if ($logoPathTime2 && file_exists($logoPathTime2)) {
    $logo2 = imagecreatefromstring(file_get_contents($logoPathTime2));
    $logo2_w = imagesx($logo2); $logo2_h = imagesy($logo2);
    $x2 = $largura - $escudo_tam - 80;
    imagecopyresampled($img, $logo2, $x2, $escudo_y, 0, 0, $escudo_tam, $escudo_tam, $logo2_w, $logo2_h);
    imagedestroy($logo2);
}
// Bola central
if (file_exists($bola_path)) {
    $bola = imagecreatefrompng($bola_path);
    $bola_w = imagesx($bola); $bola_h = imagesy($bola);
    $bola_tam = intval($escudo_tam * 1.5);
    $bola_x = ($largura - $bola_tam) / 2; $bola_y = $escudo_y;
    imagecopyresampled($img, $bola, $bola_x, $bola_y, 0, 0, $bola_tam, $bola_tam, $bola_w, $bola_h);
    imagedestroy($bola);
}
$y = $escudo_y + $escudo_tam + $espacamento;

// Nomes dos times
$font_size_time = 38;
$box1 = imagettfbbox($font_size_time, 0, $fonte_path_times, strtoupper($time1));
$width1 = $box1[2] - $box1[0];
$height1 = abs($box1[7] - $box1[1]);
$time1_x = 80 + ($escudo_tam - $width1) / 2;
$time1_y = $y + $height1;
imagettftext($img, $font_size_time, 0, $time1_x, $time1_y, $cor_texto_unica, $fonte_path_times, strtoupper($time1));

$box2 = imagettfbbox($font_size_time, 0, $fonte_path_times, strtoupper($time2));
$width2 = $box2[2] - $box2[0];
$height2 = abs($box2[7] - $box2[1]);
$time2_x = $largura - $escudo_tam - 80 + ($escudo_tam - $width2) / 2;
$time2_y = $y + $height2;
imagettftext($img, $font_size_time, 0, $time2_x, $time2_y, $cor_texto_unica, $fonte_path_times, strtoupper($time2));

// Confronto central
$confronto_font = 56;
$confronto_str = strtoupper($confronto);
$confronto_box = imagettfbbox($confronto_font, 0, $fonte_path_titulo, $confronto_str);
$confronto_x = alinhar($alinhamento, $largura, $confronto_box, 40);
$confronto_height = abs($confronto_box[7] - $confronto_box[1]);
$confronto_y = $y + $confronto_height + 20;
imagettftext($img, $confronto_font, 0, $confronto_x, $confronto_y, $cor_texto_unica, $fonte_path_titulo, $confronto_str);

$y = $confronto_y + $espacamento;

// Mensagem extra
if ($mensagem_extra) {
    $msg_font = 28;
    $msg_box = imagettfbbox($msg_font, 0, $fonte_path_info, $mensagem_extra);
    $msg_x = alinhar($alinhamento, $largura, $msg_box, 40);
    $msg_height = abs($msg_box[7] - $msg_box[1]);
    imagettftext($img, $msg_font, 0, $msg_x, $y + $msg_height, $cor_texto_unica, $fonte_path_info, $mensagem_extra);
    $y += $msg_height + $espacamento;
}

// --- RODAPÉ: botão centralizado (MAIOR e moderno) ---
$botao_nova_largura = 420; // maior
$botao_nova_altura = 100;  // maior
$botao_margem_inferior = 40;

$botao_x = ($largura - $botao_nova_largura) / 2;
$botao_y = $altura - $botao_nova_altura - $botao_margem_inferior;

if (file_exists($botao_path)) {
    $botao = imagecreatefrompng($botao_path);
    $botao_w = imagesx($botao); $botao_h = imagesy($botao);
    imagecopyresampled($img, $botao, $botao_x, $botao_y, 0, 0, $botao_nova_largura, $botao_nova_altura, $botao_w, $botao_h);
    imagedestroy($botao);
    // Botão não recebe texto
}

// Salva o banner
$nome_arquivo = $pasta . 'banner_futebol.png';
imagepng($img, $nome_arquivo);
imagedestroy($img);

header("Location: admin.php?mensagem=Banner criado com sucesso!");
ob_end_flush();
exit;
?>
